/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.registry;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.CabinetBlock;
import de.cristelknight.doapi.common.block.ChairBlock;
import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import satisfy.beachparty.Beachparty;
import satisfy.beachparty.BeachpartyIdentifier;
import satisfy.beachparty.block.BeachChairBlock;
import satisfy.beachparty.block.BeachTowelBlock;
import satisfy.beachparty.block.CocktailBlock;
import satisfy.beachparty.block.CoconutBlock;
import satisfy.beachparty.block.DeckChairBlock;
import satisfy.beachparty.block.HammockBlock;
import satisfy.beachparty.block.HangingCoconutBlock;
import satisfy.beachparty.block.LoungeChairBlock;
import satisfy.beachparty.block.MessageInABottleBlock;
import satisfy.beachparty.block.MiniFridgeBlock;
import satisfy.beachparty.block.PalmLeavesBlock;
import satisfy.beachparty.block.PalmSaplingBlock;
import satisfy.beachparty.block.ParasolBlock;
import satisfy.beachparty.block.RadioBlock;
import satisfy.beachparty.block.SandBucketBlock;
import satisfy.beachparty.block.SandCastleBlock;
import satisfy.beachparty.block.SandPileBlock;
import satisfy.beachparty.block.SeashellBlock;
import satisfy.beachparty.block.TableBlock;
import satisfy.beachparty.block.TallTorchBlock;
import satisfy.beachparty.block.TikiBarBlock;
import satisfy.beachparty.block.TikiChairBlock;
import satisfy.beachparty.item.CoconutItem;
import satisfy.beachparty.item.DrinkBlockItem;
import satisfy.beachparty.item.DrinkItem;
import satisfy.beachparty.item.MessageInABottleItem;
import satisfy.beachparty.item.PoolNoodleItem;
import satisfy.beachparty.item.SandBucketItem;
import satisfy.beachparty.item.SeashellItem;
import satisfy.beachparty.item.armor.BeachHatItem;
import satisfy.beachparty.item.armor.BeachpartyArmorItem;
import satisfy.beachparty.item.armor.BeachpartyCustomArmorItem;
import satisfy.beachparty.item.armor.DyeableBeachpartyArmorItem;
import satisfy.beachparty.registry.ArmorMaterialRegistry;
import satisfy.beachparty.registry.SoundEventRegistry;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> PALM_LEAVES = ObjectRegistry.registerWithItem("palm_leaves", () -> new PalmLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final Supplier<SaplingBlock> PALM_SAPLING = ObjectRegistry.registerWithItem("palm_sapling", PalmSaplingBlock::new);
    public static final RegistrySupplier<Block> SAND_PILE = ObjectRegistry.registerWithoutItem("sand_pile", () -> new SandPileBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283761_)));
    public static final RegistrySupplier<Block> STRIPPED_PALM_LOG = ObjectRegistry.registerLog("stripped_palm_log");
    public static final RegistrySupplier<Block> PALM_LOG = ObjectRegistry.registerLog("palm_log");
    public static final RegistrySupplier<Block> STRIPPED_PALM_WOOD = ObjectRegistry.registerLog("stripped_palm_wood");
    public static final RegistrySupplier<Block> PALM_WOOD = ObjectRegistry.registerLog("palm_wood");
    public static final RegistrySupplier<Block> PALM_BEAM = ObjectRegistry.registerLog("palm_beam");
    public static final RegistrySupplier<Block> PALM_PLANKS = ObjectRegistry.registerWithItem("palm_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> PALM_FLOORBOARD = ObjectRegistry.registerWithItem("palm_floorboard", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> PALM_STAIRS = ObjectRegistry.registerWithItem("palm_stairs", () -> new StairBlock(((Block)PALM_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get()))));
    public static final RegistrySupplier<Block> PALM_SLAB = ObjectRegistry.registerWithItem("palm_slab", () -> new SlabBlock(ObjectRegistry.getSlabSettings()));
    public static final RegistrySupplier<Block> PALM_FENCE = ObjectRegistry.registerWithItem("palm_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistrySupplier<Block> PALM_FENCE_GATE = ObjectRegistry.registerWithItem("palm_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_), WoodType.f_244200_));
    public static final RegistrySupplier<Block> PALM_BUTTON = ObjectRegistry.registerWithItem("palm_button", () -> ObjectRegistry.woodenButton(FeatureFlags.f_244571_));
    public static final RegistrySupplier<Block> PALM_PRESSURE_PLATE = ObjectRegistry.registerWithItem("palm_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271088_));
    public static final RegistrySupplier<Block> PALM_DOOR = ObjectRegistry.registerWithItem("palm_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271088_));
    public static final RegistrySupplier<Block> PALM_TRAPDOOR = ObjectRegistry.registerWithItem("palm_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271088_));
    public static final RegistrySupplier<Block> DRIED_WHEAT_BLOCK = ObjectRegistry.registerWithItem("dried_wheat_block", () -> new HayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50335_)));
    public static final RegistrySupplier<Block> DRIED_WHEAT_STAIRS = ObjectRegistry.registerWithItem("dried_wheat_stairs", () -> new StairBlock(((Block)PALM_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PALM_PLANKS.get())).m_60918_(SoundType.f_56740_)));
    public static final RegistrySupplier<Block> DRIED_WHEAT_SLAB = ObjectRegistry.registerWithItem("dried_wheat_slab", () -> new SlabBlock(ObjectRegistry.getSlabSettings().m_60918_(SoundType.f_56740_)));
    public static final RegistrySupplier<Block> LOUNGE_CHAIR = ObjectRegistry.registerWithItem("lounge_chair", () -> new LoungeChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> CHAIR = ObjectRegistry.registerWithItem("chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> TABLE = ObjectRegistry.registerWithItem("table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> BEACH_CHAIR = ObjectRegistry.registerWithItem("beach_chair", () -> new BeachChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> DECK_CHAIR = ObjectRegistry.registerWithItem("deck_chair", () -> new DeckChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> HAMMOCK = ObjectRegistry.registerWithItem("hammock", () -> new HammockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> TIKI_CHAIR = ObjectRegistry.registerWithItem("tiki_chair", () -> new TikiChairBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> TIKI_BAR = ObjectRegistry.registerWithItem("tiki_bar", () -> new TikiBarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_), (Supplier)DoApiSoundEventRegistry.CABINET_OPEN, (Supplier)DoApiSoundEventRegistry.CABINET_CLOSE));
    public static final RegistrySupplier<Block> MINI_FRIDGE = ObjectRegistry.registerWithItem("mini_fridge", () -> new MiniFridgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_)));
    public static final RegistrySupplier<Block> RADIO = ObjectRegistry.registerWithItem("radio", () -> new RadioBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Item> OVERGROWN_DISC = ObjectRegistry.registerItem("overgrown_disc", () -> new RecordItem(1, (SoundEvent)SoundEventRegistry.RADIO_BEACHPARTY.get(), ObjectRegistry.getSettings().m_41487_(1), 196));
    public static final RegistrySupplier<Block> MESSAGE_IN_A_BOTTLE = ObjectRegistry.registerWithoutItem("message_in_a_bottle", () -> new MessageInABottleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)));
    public static final RegistrySupplier<Item> MESSAGE_IN_A_BOTTLE_ITEM = ObjectRegistry.registerItem("message_in_a_bottle", () -> new MessageInABottleItem((Block)MESSAGE_IN_A_BOTTLE.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SEASHELL_BLOCK = ObjectRegistry.registerWithoutItem("seashell_block", () -> new SeashellBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_).m_60966_().m_246721_()));
    public static final RegistrySupplier<Item> SEASHELL = ObjectRegistry.registerItem("seashell", () -> new SeashellItem((Block)SEASHELL_BLOCK.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> SAND_BUCKET_BLOCK = ObjectRegistry.registerWithoutItem("sand_bucket_block", () -> new SandBucketBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_271197_)));
    public static final RegistrySupplier<Block> EMPTY_SAND_BUCKET_BLOCK = ObjectRegistry.registerWithoutItem("empty_sand_bucket_block", () -> new SandBucketBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50200_)));
    public static final RegistrySupplier<Item> SAND_BUCKET = ObjectRegistry.registerItem("sand_bucket", () -> new SandBucketItem((Block)SAND_BUCKET_BLOCK.get(), ObjectRegistry.getSettings().m_41487_(1)));
    public static final RegistrySupplier<Item> EMPTY_SAND_BUCKET = ObjectRegistry.registerItem("empty_sand_bucket", () -> new SandBucketItem((Block)EMPTY_SAND_BUCKET_BLOCK.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> COCONUT_BLOCK = ObjectRegistry.registerWithoutItem("coconut_block", () -> new CoconutBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50571_)));
    public static final RegistrySupplier<Item> COCONUT = ObjectRegistry.registerItem("coconut", () -> new CoconutItem((Block)COCONUT_BLOCK.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> COCONUT_OPEN = ObjectRegistry.registerItem("coconut_open", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Block> COCONUT_COCKTAIL = ObjectRegistry.registerCocktail("coconut_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19600_);
    public static final RegistrySupplier<Block> SWEETBERRIES_COCKTAIL = ObjectRegistry.registerCocktail("sweetberries_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19617_);
    public static final RegistrySupplier<Block> COCOA_COCKTAIL = ObjectRegistry.registerCocktail("cocoa_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19605_);
    public static final RegistrySupplier<Block> PUMPKIN_COCKTAIL = ObjectRegistry.registerCocktail("pumpkin_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19607_);
    public static final RegistrySupplier<Block> HONEY_COCKTAIL = ObjectRegistry.registerCocktail("honey_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19598_);
    public static final RegistrySupplier<Block> MELON_COCKTAIL = ObjectRegistry.registerCocktail("melon_cocktail", () -> new CocktailBlock(ObjectRegistry.getCocktailSettings()), MobEffects.f_19621_);
    public static final RegistrySupplier<Item> SWEETBERRY_MILKSHAKE = ObjectRegistry.registerItem("sweetberry_milkshake", () -> new DrinkItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_), 32));
    public static final RegistrySupplier<Item> COCONUT_MILKSHAKE = ObjectRegistry.registerItem("coconut_milkshake", () -> new DrinkItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_), 32));
    public static final RegistrySupplier<Item> CHOCOLATE_MILKSHAKE = ObjectRegistry.registerItem("chocolate_milkshake", () -> new DrinkItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_), 32));
    public static final RegistrySupplier<Item> SWEETBERRY_ICECREAM = ObjectRegistry.registerItem("sweetberry_icecream", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38808_)));
    public static final RegistrySupplier<Item> COCONUT_ICECREAM = ObjectRegistry.registerItem("coconut_icecream", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38808_)));
    public static final RegistrySupplier<Item> CHOCOLATE_ICECREAM = ObjectRegistry.registerItem("chocolate_icecream", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38808_)));
    public static final RegistrySupplier<Item> REFRESHING_DRINK = ObjectRegistry.registerItem("refreshing_drink", () -> new DrinkItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_), 32));
    public static final RegistrySupplier<Item> ICECREAM_COCONUT = ObjectRegistry.registerItem("icecream_coconut", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Item> ICECREAM_MELON = ObjectRegistry.registerItem("icecream_melon", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Item> ICECREAM_CACTUS = ObjectRegistry.registerItem("icecream_cactus", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Item> ICECREAM_SWEETBERRIES = ObjectRegistry.registerItem("icecream_sweetberries", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Item> ICECREAM_CHOCOLATE = ObjectRegistry.registerItem("icecream_chocolate", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38816_)));
    public static final RegistrySupplier<Item> RAW_MUSSEL_MEAT = ObjectRegistry.registerItem("raw_mussel_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38812_)));
    public static final RegistrySupplier<Item> COOKED_MUSSEL_MEAT = ObjectRegistry.registerItem("cooked_mussel_meat", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_)));
    public static final RegistrySupplier<Block> BEACH_TOWEL = ObjectRegistry.registerWithItem("beach_towel", () -> new BeachTowelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistrySupplier<Item> BEACH_HAT = ObjectRegistry.registerItem("beach_hat", () -> new BeachHatItem(ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> SUNGLASSES = ObjectRegistry.registerItem("sunglasses", () -> new BeachpartyArmorItem(ArmorMaterialRegistry.SUNGLASSES, ArmorItem.Type.HELMET, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TRUNKS = ObjectRegistry.registerItem("trunks", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.TRUNKS, ArmorItem.Type.LEGGINGS, 0xFF0F0F, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BIKINI = ObjectRegistry.registerItem("bikini", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.BIKINI, ArmorItem.Type.LEGGINGS, 987135, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> CROCS = ObjectRegistry.registerItem("crocs", () -> new DyeableBeachpartyArmorItem(ArmorMaterialRegistry.CROCS, ArmorItem.Type.BOOTS, 1048335, ObjectRegistry.getSettings().m_41497_(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> SWIM_WINGS = ObjectRegistry.registerItem("swim_wings", () -> new BeachpartyArmorItem(ArmorMaterialRegistry.SWIM_WINGS, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> RUBBER_RING_BLUE = ObjectRegistry.registerItem("rubber_ring_blue", () -> new BeachpartyCustomArmorItem(ArmorMaterialRegistry.RING, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON), new BeachpartyIdentifier("textures/entity/rubber_ring_blue.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_PINK = ObjectRegistry.registerItem("rubber_ring_pink", () -> new BeachpartyCustomArmorItem(ArmorMaterialRegistry.RING, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON), new BeachpartyIdentifier("textures/entity/rubber_ring_pink.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_STRIPPED = ObjectRegistry.registerItem("rubber_ring_stripped", () -> new BeachpartyCustomArmorItem(ArmorMaterialRegistry.RING, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON), new BeachpartyIdentifier("textures/entity/rubber_ring_stripped.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_PELICAN = ObjectRegistry.registerItem("rubber_ring_pelican", () -> new BeachpartyCustomArmorItem(ArmorMaterialRegistry.RING, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.RARE), new BeachpartyIdentifier("textures/entity/rubber_ring_pelican.png")));
    public static final RegistrySupplier<Item> RUBBER_RING_AXOLOTL = ObjectRegistry.registerItem("rubber_ring_axolotl", () -> new BeachpartyCustomArmorItem(ArmorMaterialRegistry.RING, ArmorItem.Type.CHESTPLATE, ObjectRegistry.getSettings().m_41497_(Rarity.RARE), new BeachpartyIdentifier("textures/entity/rubber_ring_axolotl.png")));
    public static final RegistrySupplier<Item> POOL_NOODLE = ObjectRegistry.registerItem("pool_noodle", () -> new PoolNoodleItem((Tier)Tiers.WOOD, 1, -1.4f, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> BEACH_PARASOL = ObjectRegistry.registerWithItem("beach_parasol", () -> new ParasolBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_)));
    public static final RegistrySupplier<Block> PALM_TORCH = ObjectRegistry.registerWithoutItem("palm_torch", () -> new TorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60910_().m_60966_().m_60953_(state -> 14).m_60918_(SoundType.f_56736_), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistrySupplier<Block> PALM_WALL_TORCH = ObjectRegistry.registerWithoutItem("palm_wall_torch", () -> new WallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60910_().m_60966_().m_60953_(state -> 14).m_60918_(SoundType.f_56736_).m_60916_((Block)PALM_TORCH.get()), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistrySupplier<Item> PALM_TORCH_ITEM = ObjectRegistry.registerItem("palm_torch_item", () -> new StandingAndWallBlockItem((Block)PALM_TORCH.get(), (Block)PALM_WALL_TORCH.get(), ObjectRegistry.getSettings(), Direction.DOWN));
    public static final RegistrySupplier<Block> PALM_TALL_TORCH = ObjectRegistry.registerWithItem("palm_tall_torch", () -> new TallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60910_().m_60966_().m_60953_(state -> 14).m_60918_(SoundType.f_56736_), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistrySupplier<Block> SANDCASTLE = ObjectRegistry.registerWithoutItem("sandcastle", () -> new SandCastleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)));
    public static final RegistrySupplier<Block> COCONUT_HANGING = ObjectRegistry.registerWithoutItem("coconut_hanging", () -> new HangingCoconutBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50571_)));
    public static final RegistrySupplier<Block> SANDWAVES = ObjectRegistry.registerWithItem("sandwaves", () -> new SandBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283761_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final RegistrySupplier<Block> SAND_SEASTARS = ObjectRegistry.registerWithoutItem("sand_seastars", () -> new SandBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283761_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));

    private static RegistrySupplier<Block> registerLog(String path) {
        return ObjectRegistry.registerWithItem(path, () -> new RotatedPillarBlock(ObjectRegistry.getLogBlockSettings()));
    }

    private static BlockBehaviour.Properties getLogBlockSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    private static BlockBehaviour.Properties getSlabSettings() {
        return ObjectRegistry.getLogBlockSettings().m_155956_(3.0f);
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static FoodProperties cocktailFoodComponent(MobEffect effect) {
        FoodProperties.Builder component = new FoodProperties.Builder().m_38760_(2).m_38758_(1.0f);
        if (effect != null) {
            component.m_38762_(new MobEffectInstance(effect, 900), 1.0f);
        }
        return component.m_38767_();
    }

    private static BlockBehaviour.Properties getCocktailSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60966_();
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static void init() {
        Beachparty.LOGGER.debug("Registering Mod Block and Items for beachparty");
        ITEMS.register();
        BLOCKS.register();
    }

    public static void commonInit() {
        FuelRegistry.register((int)300, (ItemLike[])new ItemLike[]{(ItemLike)PALM_FENCE.get(), (ItemLike)PALM_FENCE_GATE.get(), (ItemLike)PALM_PLANKS.get(), (ItemLike)PALM_LOG.get(), (ItemLike)PALM_WOOD.get(), (ItemLike)STRIPPED_PALM_LOG.get(), (ItemLike)STRIPPED_PALM_WOOD.get()});
    }

    private static ButtonBlock woodenButton(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            properties = properties.m_246843_(featureFlags);
        }
        return new ButtonBlock(properties, BlockSetType.f_271088_, 30, true);
    }

    private static <T extends Block> RegistrySupplier<T> registerCocktail(String name, Supplier<T> block, MobEffect effect) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((Block)toReturn.get(), ObjectRegistry.getSettings(settings -> settings.m_41489_(ObjectRegistry.cocktailFoodComponent(effect)))));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BeachpartyIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new BeachpartyIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)new BeachpartyIdentifier(path), itemSupplier);
    }
}

